import { StageStatusPage } from '../../../page_objects/stage/StageStatusPage';
import { getStageName, STAGE_LOCATIONS, TIMEOUTS } from '../../../utils';

context('StageStatus', () => {
   const stageName = getStageName('status_check');
   const statusStagePage = new StageStatusPage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      cy.deleteStage(stageName);
      cy.fixture('simpleStage.json').then(simpleStage => {
         simpleStage.meta.id = stageName;

         const clusters = STAGE_LOCATIONS.map(v => ({
            'cluster': v,
            'spec': {
               'replica_count': 1,
            },
         }));
         clusters[clusters.length - 1].spec.replica_count = 11;
         simpleStage.spec.deploy_units.deployUnit.multi_cluster_replica_set.replica_set.clusters = clusters;
         simpleStage.spec.deploy_units.deployUnit.multi_cluster_replica_set.replica_set.deployment_strategy.max_unavailable =
            clusters.length;

         cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.createStage(simpleStage));
      });
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('should support status page', () => {
      const replicaSet = statusStagePage.statusReplicaSet(0);
      cy.visit(statusStagePage.pathname);
      replicaSet.visit({ timeout: TIMEOUTS.stageReadyAfterSave });
      replicaSet.tabs.pods.visit();

      STAGE_LOCATIONS.map((location, i) => {
         replicaSet.tabs.pods.filters.location
            .getMeta(location, { timeout: TIMEOUTS.stageReadyAfterSave })
            .should('have.text', i === STAGE_LOCATIONS.length - 1 ? '11' : '1'); // ждём не полной подготовки стейджа, а просто списка подов
      });

      replicaSet.tabs.status.visit();
      replicaSet.tabs.endpoints.visit();
      replicaSet.tabs.disruptionBudget.visit();

      replicaSet.tabs.pods.visit();
      replicaSet.tabs.pods.filters.location.set(STAGE_LOCATIONS[STAGE_LOCATIONS.length - 1]); // работает при bigCluster === 'myt'

      const podTab = replicaSet.tabs.pods;

      // row check
      const podRow = podTab.table.rows(0);

      podRow.get('self').should('be.visible');

      podRow.get('self').should('exist');
      podRow.get('revision').should('include.text', '1');

      cy.get(podRow.additional).should('not.exist');
      podRow.get('index').click();
      cy.get(podRow.additional).should('exist');
      podRow.get('index').click();
      cy.get(podRow.additional).should('not.exist');

      // pagination check
      podTab.table.pagination.podPerPageCount.check('10');
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPage.set('2');
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPage.check('2');
      podTab.table.loader.waitForHide();

      podTab.table.pagination.podPerPageCount.set('20');
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPage.check('2'); // Это неверное поведение! Должно быть '1'. DEPLOY-6019
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPerPageCount.set('10');
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPage.set('1');

      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPerPageCount.set('20');
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPerPageCount.set('50');
      podTab.table.loader.waitForHide();
      podTab.table.pagination.podPerPageCount.set('100');

      // Filters check
      podTab.filters.status.check('any status');
      podTab.filters.revision.check('any revision');

      podTab.filters.status.set('status is ready');
      podTab.table.loader.waitForHide();

      podTab.filters.revision.set('current revision: 1');
      podTab.table.loader.waitForHide();

      podTab.filters.status.set('any status');
      podTab.table.loader.waitForHide();

      podTab.filters.revision.set('any revision');
      podTab.table.loader.waitForHide();

      podRow.get('self').should('be.visible');
   });
});
