import { YCSuggestField } from 'page_objects/components';
import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageUpdatePage } from 'page_objects/stage/StageUpdatePage';
import { BYTES, getStageName, TIMEOUTS } from '../../../../utils';

context('StageHugeFormEdit', () => {
   const stageName = getStageName('stage-huge-form-edit');
   const deployUnitName = 'deployUnit';
   const networkBandwidthUpdate = 'networkBandwidthUpdate';

   const stageEditPage = new StageEditPage(stageName);
   const stageUpdatePage = new StageUpdatePage(stageName);

   const deployUnitEdit = stageEditPage.hugeForm.deployUnit(deployUnitName);

   const stageEditGroupCheckbox = stageEditPage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageEditDuCheckbox = stageEditPage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   const stageUpdateGroupCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageUpdateDuCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should show stage edit updates', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageUpdatePage.visit();

         cy.log('обновлений не требуется');

         stageUpdatePage.stagePatcherOptions.isEmpty();

         stageUpdatePage.buttons.update.should('exist').should('be.disabled');

         /*******************************************
          * custom networkBandwidthGuarantee update *
          *******************************************/

         stageEditPage.visit();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();

         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '1', // simple stage value
         });

         cy.log('обновлений не требуется');

         stageEditPage.showDiff();
         stageEditPage.diffView.close();

         deployUnitEdit.form.set({
            networkBandwidthGuarantee: '2',
         });

         cy.log('custom networkBandwidthUpdate update from UI (#1)');

         stageEditPage.showDiff();
         stageEditPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', (1 * BYTES.MB).toString());
         stageEditPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (2 * BYTES.MB).toString());
         stageEditPage.diffView.deploy('custom networkBandwidthUpdate update from UI (#1)');

         /******************************************
          * empty networkBandwidthGuarantee update *
          ******************************************/

         stageEditPage.visit();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();

         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '2',
         });

         cy.log('нет полей для обновления');

         stageEditPage.showDiff();

         stageEditPage.diffView.close();

         cy.log('обнуляем networkBandwidthGuarantee');

         deployUnitEdit.form.set({
            networkBandwidthGuarantee: '',
         });

         cy.log('появляется страница апдейтов');

         /******************************************
          * проверяем diff с включенными галочками *
          ******************************************/

         cy.log('проверяем diff с включенными галочками');

         stageEditPage.showUpdates();

         cy.get(stageEditDuCheckbox).should('exist').should('be.checked');
         cy.get(stageEditGroupCheckbox).should('exist').should('be.checked');

         stageEditPage.showDiff();

         stageEditPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', (2 * BYTES.MB).toString());
         stageEditPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
         stageEditPage.diffView.close();

         /*******************************************
          * проверяем diff с выключенными галочками *
          *******************************************/

         stageEditPage.showUpdates();

         cy.get(stageEditDuCheckbox).should('be.checked');
         cy.get(stageEditGroupCheckbox).should('be.checked').click();

         cy.get(stageEditGroupCheckbox).should('not.be.checked');
         cy.get(stageEditDuCheckbox).should('not.be.checked');

         stageEditPage.showDiff();

         stageEditPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', (2 * BYTES.MB).toString());
         // stageEditPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', '');
         stageEditPage.diffView.close();

         /***************************************************
          * выключаем галочки и закрываем страницу апдейтов *
          ***************************************************/

         stageEditPage.showUpdates();

         cy.log('проверяем, что по дефолту галочки включены и снимаем');

         cy.get(stageEditDuCheckbox).should('exist').should('be.checked');
         cy.get(stageEditGroupCheckbox).should('exist').should('be.checked').click();

         cy.get(stageEditGroupCheckbox).should('not.be.checked');
         cy.get(stageEditDuCheckbox).should('not.be.checked');

         cy.log('закрываем страницу апдейтов');

         stageEditPage.stagePatcherOptions.close();

         /******************************
          * деплоим стейдж без галочек *
          ******************************/

         stageEditPage.showUpdates();

         cy.log('после закрытия diff и возврата к форме все галочки снова включены');

         cy.get(stageEditDuCheckbox).should('be.checked').click();

         cy.get(stageEditGroupCheckbox).should('not.be.checked');
         cy.get(stageEditDuCheckbox).should('not.be.checked');

         cy.log('empty networkBandwidthUpdate update from UI (#2)');

         stageEditPage.showDiff();

         stageEditPage.diffView.deploy('empty networkBandwidthUpdate update from UI (#2)');

         /********************************************************
          * recommended default networkBandwidthGuarantee update *
          ********************************************************/

         stageUpdatePage.visit();

         cy.log('по дефолту галочки включены и кнопка не disabled');

         stageUpdatePage.buttons.update.should('exist').should('not.be.disabled');
         cy.get(stageUpdateDuCheckbox).should('exist').should('be.checked');
         cy.get(stageUpdateGroupCheckbox).should('exist').should('be.checked').click();

         cy.get(stageUpdateGroupCheckbox).should('not.be.checked');
         cy.get(stageUpdateDuCheckbox).should('not.be.checked');
         stageUpdatePage.buttons.update.should('be.disabled');

         stageEditPage.visit();

         stageEditPage.showUpdates();
         stageEditPage.showDiff();

         stageEditPage.diffView.close();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();
         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '', // должно быть пусто
         });

         stageEditPage.showUpdates();

         cy.log('проверяем, что по дефолту галочки включены');

         cy.get(stageEditDuCheckbox).should('be.checked');
         cy.get(stageEditGroupCheckbox).should('be.checked');

         cy.log('default networkBandwidthUpdate update from UI (#3)');

         stageEditPage.showDiff();

         // stageEditPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', '');
         stageEditPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
         stageEditPage.diffView.deploy('default networkBandwidthUpdate update from UI (#3)');

         cy.log('больше нечего обновлять');

         stageUpdatePage.visit();
         stageUpdatePage.stagePatcherOptions.isEmpty();

         stageEditPage.visit();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();

         stageEditPage.showDiff();

         stageEditPage.diffView.close();

         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '10', // recommended default
         });
      });
   });
});
