import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageUpdatePage } from 'page_objects/stage/StageUpdatePage';
import { StageHistoryPage } from 'page_objects/stage/StageHistoryPage';
import { BYTES, getStageName } from '../../../../utils';

context('StageHugeFormHistory', () => {
   const stageName = getStageName('stage-huge-form-history');
   const deployUnitName = 'deployUnit';
   const networkBandwidthUpdate = 'networkBandwidthUpdate';

   const stageEditPage = new StageEditPage(stageName);
   const stageUpdatePage = new StageUpdatePage(stageName);
   const stageHistoryPage = new StageHistoryPage(stageName);

   const deployUnitEdit = stageEditPage.hugeForm.deployUnit(deployUnitName);

   const stageEditGroupCheckbox = stageEditPage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageEditDuCheckbox = stageEditPage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   const stageUpdateGroupCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageUpdateDuCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should show stage history updates', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageUpdatePage.visit();

         cy.log('В первой ревизии стейджа нечего обновлять');

         stageUpdatePage.stagePatcherOptions.isEmpty();

         stageEditPage.visit();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();
         deployUnitEdit.form.set({
            networkBandwidthGuarantee: '',
         });

         cy.log('После обнуления поля появляется страница апдейтов');

         stageEditPage.showUpdates();

         cy.get(stageEditGroupCheckbox).should('be.checked');
         cy.get(stageEditDuCheckbox).should('be.checked').click();
         cy.get(stageEditDuCheckbox).should('not.be.checked');
         cy.get(stageEditGroupCheckbox).should('not.be.checked');

         stageEditPage.showDiff();

         stageEditPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', (1 * BYTES.MB).toString());
         // stageEditPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', '');

         cy.log('Создаём вторую ревизию с пустым networkBandwidthGuarantee');

         stageEditPage.diffView.deploy('update from UI: empty networkBandwidthUpdate');

         cy.log('Проверяем страницу апдейтов стейджа');

         stageUpdatePage.visit();

         stageUpdatePage.buttons.update.should('exist').should('not.be.disabled');
         cy.get(stageUpdateDuCheckbox).should('exist').should('be.checked');
         cy.get(stageUpdateGroupCheckbox).should('exist').should('be.checked');

         /******************************************************************
          * APPLY AS IS: 1 ревизия с заполненным networkBandwidthGuarantee *
          * тут не должны показывать ошибки и страницу апдейтов            *
          ******************************************************************/

         cy.log('Создаём третью ревизию с apply as is (from revision 1)');

         stageHistoryPage.applyAsIs(1);

         stageHistoryPage.diffView.descriptionField.check('Revert to changes from revision 1');
         stageHistoryPage.diffView.deploy('Apply revision 1 as is');

         stageEditPage.visit();

         cy.log('проверяем заполненный networkBandwidthGuarantee');
         cy.get(deployUnitEdit.treeItem.linkSelector).click();
         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '1',
         });

         /*************************************************************
          * APPLY AS IS: 2 ревизия с пустым networkBandwidthGuarantee *
          * тут не должны показывать ошибки и страницу апдейтов       *
          *************************************************************/

         cy.log('Создаём четвёртую ревизию с apply as is (from revision 2)');

         stageHistoryPage.applyAsIs(2);

         stageHistoryPage.diffView.descriptionField.check('Revert to changes from revision 2');
         stageHistoryPage.diffView.deploy('Apply revision 2 as is');

         stageEditPage.visit();

         cy.log('проверяем пустой networkBandwidthGuarantee');
         cy.get(deployUnitEdit.treeItem.linkSelector).click();
         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '',
         });

         /***********************************************************************
          * APPLY WITH CHANGES #1                                               *
          * тут должны показывать ошибки и страницу апдейтов там, где они нужны *
          ***********************************************************************/

         cy.log('Создаём пятую ревизию с apply with changes (from revision 3)');

         stageHistoryPage.applyWithChanges(3);

         const deployUnitHistoryRevision3 = stageHistoryPage.revisionHugeForm('3').deployUnit(deployUnitName);

         cy.log('set networkBandwidthGuarantee = 5');
         cy.get(deployUnitHistoryRevision3.treeItem.linkSelector).click();
         deployUnitHistoryRevision3.form.check({
            networkBandwidthGuarantee: '1',
         });

         stageHistoryPage.showDiff();
         // stageHistoryPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', '');
         stageHistoryPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (1 * BYTES.MB).toString());
         stageHistoryPage.diffView.close();

         deployUnitHistoryRevision3.form.set({
            networkBandwidthGuarantee: '5',
         });

         cy.log('custom networkBandwidthUpdate update from UI');
         stageHistoryPage.showDiff();
         // stageHistoryPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', '');
         stageHistoryPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (5 * BYTES.MB).toString());
         stageHistoryPage.diffView.deploy('Apply with changes from revision 3');

         stageEditPage.visit();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();
         cy.log('проверяем networkBandwidthGuarantee = 5');
         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '5',
         });

         stageUpdatePage.visit();
         stageUpdatePage.stagePatcherOptions.isEmpty();

         /***********************************************************************
          * APPLY WITH CHANGES #2                                               *
          * тут должны показывать ошибки и страницу апдейтов там, где они нужны *
          ***********************************************************************/

         cy.log('Создаём шестую ревизию с apply with changes (from revision 4)');

         stageHistoryPage.applyWithChanges(4);

         const deployUnitHistoryRevision4 = stageHistoryPage.revisionHugeForm('4').deployUnit(deployUnitName);

         cy.get(deployUnitHistoryRevision4.treeItem.linkSelector).click();
         deployUnitHistoryRevision4.form.check({
            networkBandwidthGuarantee: '',
         });

         cy.log('Появляется страница апдейтов');

         stageHistoryPage.showUpdates();

         cy.log('по дефолту галочки включены');

         cy.get(stageEditDuCheckbox).should('be.checked');
         cy.get(stageEditGroupCheckbox).should('be.checked');

         stageHistoryPage.showDiff();
         stageHistoryPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
         stageHistoryPage.diffView.close();

         cy.log('галочки включены');

         stageHistoryPage.showUpdates();

         cy.get(stageEditDuCheckbox).should('be.checked');
         cy.get(stageEditGroupCheckbox).should('be.checked');

         cy.log('default networkBandwidthUpdate update from UI');

         stageHistoryPage.showDiff();
         stageHistoryPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
         stageHistoryPage.diffView.descriptionField.check('Revert to changes from revision 4');
         stageHistoryPage.diffView.deploy('Apply with changes from revision 4');

         stageEditPage.visit();

         cy.log('проверяем networkBandwidthGuarantee = 5');

         cy.get(deployUnitEdit.treeItem.linkSelector).click();
         deployUnitEdit.form.check({
            networkBandwidthGuarantee: '10', // default
         });

         stageUpdatePage.visit();

         stageUpdatePage.stagePatcherOptions.isEmpty();
      });
   });
});
