import { NewStagePage } from 'page_objects/stage/NewStagePage';
import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageUpdatePage } from 'page_objects/stage/StageUpdatePage';
import { BYTES, DEFAULT_ACCOUNT_ID, DEFAULT_NETWORK, DEFAULT_PROJECT, getStageName } from '../../../../utils';

context('StageHugeFormNew', () => {
   const stageName = getStageName('stage-huge-form-new');
   const deployUnitName = 'deployUnit';
   const networkBandwidthUpdate = 'networkBandwidthUpdate';

   const newStagePage = new NewStagePage();
   const stageEditPage = new StageEditPage(stageName);
   const stageUpdatePage = new StageUpdatePage(stageName);

   const newStage = newStagePage.hugeForm.stageForm;
   const newDeployUnit = newStagePage.hugeForm.deployUnit(deployUnitName);

   const newStageGroupCheckbox = newStagePage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const newStageDuCheckbox = newStagePage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   const stageUpdateGroupCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageUpdateDuCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should show new stage updates', () => {
      cy.log('заходим на страницу создания стейджа и заполняем обязательные настройки');

      newStagePage.visit();

      newStage.form.set({
         id: stageName,

         // project вручную не проставляем (см. ниже)
         // project: DEFAULT_PROJECT,
      });

      newStage.form.check({
         // Проверяем DEFAULT_PROJECT:
         // он должен автоматически подставляться вместе с account_id для нового стейджа без ошибок (из урла)
         // если это не так, то надо чинить #DEPLOY-5640
         project: DEFAULT_PROJECT,
      });

      cy.get(newDeployUnit.treeItem.linkSelector).click();

      newDeployUnit.form.set({
         network: DEFAULT_NETWORK,
      });

      newDeployUnit.form.check({
         networkBandwidthGuarantee: '10', // default value
      });

      cy.log('открываем и закрываем дифф: обновлений не требуется');

      newStagePage.showDiff();
      newStagePage.diffView.checkInsertedFieldValue('project_id', DEFAULT_PROJECT);
      newStagePage.diffView.checkInsertedFieldValue('account_id', DEFAULT_ACCOUNT_ID); // #DEPLOY-5640
      // TODO: network
      newStagePage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
      newStagePage.diffView.close();

      cy.log('обнуляем networkBandwidthGuarantee');

      newDeployUnit.form.set({
         networkBandwidthGuarantee: '',
      });

      cy.log('появляется страница апдейтов');

      /******************************************
       * проверяем diff с включенными галочками *
       ******************************************/

      cy.log('проверяем diff с включенными галочками');

      newStagePage.showUpdates();

      cy.get(newStageDuCheckbox).should('exist').should('be.checked');
      cy.get(newStageGroupCheckbox).should('exist').should('be.checked');

      newStagePage.showDiff();

      newStagePage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
      newStagePage.diffView.close();

      /*******************************************
       * проверяем diff с выключенными галочками *
       *******************************************/

      newStagePage.showUpdates();

      cy.log('проверяем ещё раз, снова снимаем галочки и открываем/закрываем diff');

      cy.get(newStageDuCheckbox).should('exist').should('be.checked');
      cy.get(newStageGroupCheckbox).should('exist').should('be.checked').click();

      cy.get(newStageGroupCheckbox).should('not.be.checked');
      cy.get(newStageDuCheckbox).should('not.be.checked');

      newStagePage.showDiff();

      // newStagePage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', '');
      newStagePage.diffView.close();

      /***************************************************
       * выключаем галочки и закрываем страницу апдейтов *
       ***************************************************/

      newStagePage.showUpdates();

      cy.log('проверяем, что по дефолту галочки включены, снимаем и закрываем страницу апдейтов');

      cy.get(newStageGroupCheckbox).should('exist').should('be.checked');
      cy.get(newStageDuCheckbox).should('exist').should('be.checked').click();

      cy.get(newStageGroupCheckbox).should('not.be.checked');
      cy.get(newStageDuCheckbox).should('not.be.checked');

      newStagePage.stagePatcherOptions.close();

      /**************************************
       * выключаем галочки и деплоим стейдж *
       **************************************/

      newStagePage.showUpdates();

      cy.get(newStageDuCheckbox).should('exist').should('be.checked');
      cy.get(newStageGroupCheckbox).should('exist').should('be.checked').click();

      cy.get(newStageGroupCheckbox).should('not.be.checked');
      cy.get(newStageDuCheckbox).should('not.be.checked');

      newStagePage.showDiff();

      newStagePage.diffView.deploy('created from UI: empty networkBandwidthUpdate');

      stageUpdatePage.visit();

      cy.log('по дефолту галочки включены и кнопка не disabled');

      stageUpdatePage.buttons.update.should('exist').should('not.be.disabled');
      cy.get(stageUpdateDuCheckbox).should('exist').should('be.checked');
      cy.get(stageUpdateGroupCheckbox).should('exist').should('be.checked').click();

      cy.get(stageUpdateGroupCheckbox).should('not.be.checked');
      cy.get(stageUpdateDuCheckbox).should('not.be.checked');
      stageUpdatePage.buttons.update.should('be.disabled');

      stageEditPage.visit();

      cy.get(stageEditPage.hugeForm.deployUnit(deployUnitName).treeItem.linkSelector).click();

      stageEditPage.hugeForm.deployUnit(deployUnitName).form.check({
         networkBandwidthGuarantee: '', // пустое значение
      });
   });
});
