import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageUpdatePage } from 'page_objects/stage/StageUpdatePage';
import { BYTES, dataE2E, getStageName, sel } from '../../../../utils';

context('StageHugeFormUpdate', () => {
   const stageName = getStageName('stage-huge-form-update');
   const deployUnitName = 'deployUnit';
   const networkBandwidthUpdate = 'networkBandwidthUpdate';

   const stageEditPage = new StageEditPage(stageName);
   const stageUpdatePage = new StageUpdatePage(stageName);

   const deployUnitEdit = stageEditPage.hugeForm.deployUnit(deployUnitName);

   const stageEditGroupCheckbox = stageEditPage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageEditDuCheckbox = stageEditPage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   const stageUpdateGroupCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(networkBandwidthUpdate);
   const stageUpdateDuCheckbox = stageUpdatePage.stagePatcherOptions.getCheckboxSelector(
      networkBandwidthUpdate,
      deployUnitName,
   );

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should show stage updates page', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageUpdatePage.visit();
         stageUpdatePage.stagePatcherOptions.isEmpty(); // нечего обновлять

         stageEditPage.visit();

         cy.log('обнуляем networkBandwidthGuarantee');

         cy.get(deployUnitEdit.treeItem.linkSelector).click();

         deployUnitEdit.form.set({
            networkBandwidthGuarantee: '',
         });

         cy.log('появляется страница апдейтов');

         stageEditPage.showUpdates();

         cy.log('проверяем, что по дефолту галочки включены, выключаем');

         cy.get(stageEditGroupCheckbox).should('exist').should('be.checked');
         cy.get(stageEditDuCheckbox).should('exist').should('be.checked').click();

         cy.get(stageEditGroupCheckbox).should('exist').should('not.be.checked');
         cy.get(stageEditDuCheckbox).should('exist').should('not.be.checked');

         stageEditPage.showDiff();

         stageEditPage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', (1 * BYTES.MB).toString());
         // stageEditPage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', '');

         cy.log('empty networkBandwidthUpdate update from UI');

         stageEditPage.diffView.deploy('empty networkBandwidthUpdate update from UI');

         stageEditPage.visit();

         cy.get(stageEditPage.hugeForm.deployUnit(deployUnitName).treeItem.linkSelector).click();

         stageEditPage.hugeForm.deployUnit(deployUnitName).form.check({
            networkBandwidthGuarantee: '', // пустое поле
         });

         stageUpdatePage.visit();

         cy.get(sel(dataE2E('DeployUnitId')))
            .contains(deployUnitName)
            .should('exist');

         cy.get(stageUpdatePage.stagePatcherOptions.getActionSelector(networkBandwidthUpdate))
            .contains('label', 'Update Network Bandwidth Guarantee')
            .should('exist');

         cy.log('по дефолту галочки включены и кнопка не disabled');

         stageUpdatePage.buttons.update.should('exist').should('not.be.disabled');
         cy.get(stageUpdateDuCheckbox).should('exist').should('be.checked');
         cy.get(stageUpdateGroupCheckbox).should('exist').should('be.checked').click();

         cy.log('без галочек кнопка блокируется');

         stageUpdatePage.buttons.update.should('be.disabled');
         cy.get(stageUpdateGroupCheckbox).should('not.be.checked');
         cy.get(stageUpdateDuCheckbox).should('not.be.checked').click();

         cy.get(stageUpdateDuCheckbox).should('be.checked');
         cy.get(stageUpdateGroupCheckbox).should('be.checked');

         cy.log('с галочками кнопка разблокируется');

         stageUpdatePage.showDiff();

         // stageUpdatePage.diffView.checkDeletedFieldValue('network_bandwidth_guarantee', '');
         stageUpdatePage.diffView.checkInsertedFieldValue('network_bandwidth_guarantee', (10 * BYTES.MB).toString());
         stageUpdatePage.diffView.close();

         cy.log('после закрытия diff все галочки снова включены');

         cy.get(stageUpdateDuCheckbox).should('exist').should('be.checked');
         cy.get(stageUpdateGroupCheckbox).should('exist').should('be.checked').click();

         cy.log('если снимаем галочки, то кнопка опять блокируется');

         stageUpdatePage.buttons.update.should('exist').should('be.disabled');

         cy.log('ставим галку и деплоим стейдж');

         cy.get(stageUpdateDuCheckbox).should('not.be.checked').click();
         cy.get(stageUpdateDuCheckbox).should('be.checked');

         stageUpdatePage.showDiff();

         stageUpdatePage.diffView.deploy();

         cy.log('обновлений больше нет');

         stageUpdatePage.visit();

         stageUpdatePage.stagePatcherOptions.isEmpty();

         stageEditPage.visit();

         cy.get(stageEditPage.hugeForm.deployUnit(deployUnitName).treeItem.linkSelector).click();

         stageEditPage.hugeForm.deployUnit(deployUnitName).form.check({
            networkBandwidthGuarantee: '10', // дефолтное значение
         });
      });
   });
});
