import { dataE2E, getStageName, sel, SERVICE, SERVICES } from '../../../../utils';

import {
   ProbeMode,
   WorkloadCommandsFormValue,
} from 'page_objects/stage/internal/levels/workload/fields/WorkloadCommandsForm';

import { StageConfigPage } from 'page_objects/stage/StageConfigPage';
import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageStatusPage } from 'page_objects/stage/StageStatusPage';

const docker = {
   name: 'deploy.ui/deploy-ui',
   tag: '0.0.100',
};

const RUN = 'export CONSOLE_ENV=ext-test; cd /opt/app; /usr/bin/supervisord -c /etc/supervisor/supervisord.conf';

const commands: WorkloadCommandsFormValue[] = [
   {
      start: {
         command: '/bin/bash /run.sh',
      },
      init: [
         {
            order: 1,
            command: `bash -c 'printf "${RUN}" > ./run.sh'`,
         },
         {
            order: 2,
            command: `bash -c 'printf "init test" > ./init-test'`,
         },
      ],

      liveness: {
         // TODO: решить проблему с YCRadioField readonly (title !== value)
         // mode: ProbeMode.TCP,
         tcp: {
            port: '80',
         },
      },
   },
];

context('BoxDocker', () => {
   const stageName = getStageName('box_docker');

   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);
   const stageStatusPage = new StageStatusPage(stageName);

   const boxForm = stageEditPage.hugeForm.box('deployUnit', 'box');
   const workloadForm = stageEditPage.hugeForm.workload('deployUnit', 'box', 'workload');

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('should edit docker', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageEditPage.visit();

         cy.get(boxForm.treeItem.linkSelector).click();
         cy.get(boxForm.formTabs.getTab('Resources')).click();

         stageEditPage.showDiff();
         stageEditPage.closeDiff();

         boxForm.form.set({
            docker: {
               enabled: true,
            },
         });

         cy.log('Show docker errors: "Docker name/tag is a required field"');
         stageEditPage.showValidationModal();
         stageEditPage.closeValidationModal();

         boxForm.form.set({
            docker: {
               name: ' whitespace',
               tag: 'whitespace ',
            },
         });

         boxForm.form.set({
            docker: {
               enabled: false,
            },
         });

         stageEditPage.showDiff();
         stageEditPage.closeDiff();

         boxForm.form.set({
            docker: {
               enabled: true,
            },
         });

         cy.log('Show docker errors: "Docker name/tag is invalid"');
         stageEditPage.showValidationModal();
         stageEditPage.closeValidationModal();

         boxForm.form.set({
            docker: {
               name: docker.name,
               tag: docker.tag,
            },
         });

         stageEditPage.showDiff();
         stageEditPage.closeDiff();

         cy.get(workloadForm.treeItem.linkSelector).click();

         workloadForm.form.check({
            commands: [
               {
                  liveness: {
                     mode: ProbeMode.TCP,
                  },
               },
            ],
         });

         workloadForm.form.set({
            commands: [
               {
                  init: [
                     {
                        order: 2,
                        add: true,
                     },
                  ],
               },
            ],
         });

         workloadForm.form.set({
            commands,
         });

         stageEditPage.deploy();

         // check new form/config values
         [stageConfigPage, stageEditPage].map((page, pageIndex) => {
            page.visit();

            const box = page.hugeForm.box('deployUnit', 'box');
            const workload = page.hugeForm.workload('deployUnit', 'box', 'workload');

            cy.get(box.treeItem.linkSelector).click();
            cy.get(box.formTabs.getTab('Resources')).click();

            // в конфиге кастомное значение
            if (pageIndex === 0) {
               cy.get(sel(dataE2E('Box:Docker')))
                  .contains('div', `https://registry.yandex.net/${docker.name}:${docker.tag}`)
                  .should('exist');
            } else {
               boxForm.form.check({
                  docker: {
                     enabled: true,
                     name: docker.name,
                     tag: docker.tag,
                  },
               });
            }

            cy.get(workload.treeItem.linkSelector).click();

            workload.form.check({
               commands,
            });

            workload.form.check({
               commands: [
                  {
                     liveness: {
                        mode: pageIndex === 0 ? undefined : ProbeMode.TCP, // TODO: решить проблему с YCRadioField readonly (title !== value)
                     },
                  },
                  {
                     readiness: {
                        mode: pageIndex === 0 ? undefined : ProbeMode.TCP, // TODO: решить проблему с YCRadioField readonly (title !== value)
                        tcp: {
                           port: '80', // default value
                        },
                     },
                  },
               ],
            });
         });

         if (SERVICE === SERVICES.BACKEND) {
            stageStatusPage.stageReadyAfterSave('2');
         }
      });
   });
});
