import { defaultOS } from '../../../../../ui/src/old-code/store/reducers/sandbox.js';
import { dataTest, getStageName, sel, SERVICE, SERVICES } from '../../../../utils';

import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageConfigPage } from 'page_objects/stage/StageConfigPage';
import { StageStatusPage } from 'page_objects/stage/StageStatusPage';

const SIMPLE_HTTP_SERVER_LAYER_ID = 'simple_http_server';
const SIMPLE_HTTP_SERVER_LAYER_URL = 'sbr:755375039';
const SIMPLE_HTTP_SERVER_LAYER_CHECKSUM = 'MD5:195fbd0b6af168c26fcc67defabf8af5';

context('BoxLayers', () => {
   const stageName = getStageName('box_layers');

   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);
   const stageStatusPage = new StageStatusPage(stageName);

   const deployUnitForm = stageEditPage.hugeForm.deployUnit('deployUnit');
   const boxForm = stageEditPage.hugeForm.box('deployUnit', 'box');

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('should edit layers', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageEditPage.visit();

         cy.get(deployUnitForm.treeItem.linkSelector).click();
         cy.get(deployUnitForm.formTabs.getTab('Disks, volumes and resources')).click();

         stageEditPage.showDiff();
         stageEditPage.closeDiff();

         deployUnitForm.form.set({
            layers: [
               {
                  order: 3,
                  add: true,
               },
               {
                  order: 1,
                  remove: true,
               },
            ],
         });

         deployUnitForm.form.set({
            layers: [
               {
                  order: 3,
                  item: {
                     type: 'custom',
                  },
               },
               {
                  order: 3,
                  item: {
                     type: defaultOS[0].value,
                  },
               },
               {
                  order: 3,
                  item: {
                     id: defaultOS[1].title,
                     type: defaultOS[1].value,
                     // url: defaultOS[1].value,
                     // checksum: 'EMPTY:',
                  },
               },
            ],
         });

         cy.log(`Show disk layer errors: "Layer is used and cannot be removed."`);
         stageEditPage.showValidationModal();
         stageEditPage.closeValidationModal();

         deployUnitForm.form.set({
            layers: [
               {
                  order: 1,
                  restore: true,
               },
               {
                  order: 2,
                  item: {
                     checksum: SIMPLE_HTTP_SERVER_LAYER_CHECKSUM,
                  },
               },
            ],
         });

         stageEditPage.showDiff();
         stageEditPage.closeDiff();

         cy.get(boxForm.treeItem.linkSelector).click();
         cy.get(boxForm.formTabs.getTab('Resources')).click();

         boxForm.form.set({
            layers: [
               {
                  order: 1,
                  item: { id: defaultOS[1].title },
               },
               {
                  order: 3,
                  add: true,
                  item: { id: defaultOS[1].title },
               },
            ],
         });

         cy.log('Show box layer errors: "Layer must be unique"');
         stageEditPage.showValidationModal();
         stageEditPage.closeValidationModal();

         boxForm.form.set({
            layers: [
               {
                  order: 3,
                  remove: true,
               },
            ],
         });

         stageEditPage.showDiff();
         stageEditPage.closeDiff();

         stageEditPage.deploy();

         // check new form/config values
         [stageConfigPage, stageEditPage].map((page, pageIndex) => {
            page.visit();

            const deployUnit = page.hugeForm.deployUnit('deployUnit');
            const box = page.hugeForm.box('deployUnit', 'box');

            cy.get(deployUnit.treeItem.linkSelector).click();
            cy.get(deployUnitForm.formTabs.getTab('Disks, volumes and resources')).click();

            deployUnit.form.check({
               layers: [
                  {
                     order: 1,
                     item: {
                        id: 'layer',
                        type: pageIndex === 0 ? undefined : defaultOS[0].value, // config/edit
                        url: defaultOS[0].value,
                     },
                  },
                  {
                     order: 2,
                     item: {
                        id: SIMPLE_HTTP_SERVER_LAYER_ID,
                        type: pageIndex === 0 ? undefined : 'custom', // config/edit
                        url: SIMPLE_HTTP_SERVER_LAYER_URL,
                        checksum: SIMPLE_HTTP_SERVER_LAYER_CHECKSUM,
                     },
                  },
                  {
                     order: 3,
                     item: {
                        id: defaultOS[1].title,
                        type: pageIndex === 0 ? undefined : defaultOS[1].value, // config/edit
                        url: defaultOS[1].value,
                     },
                  },
               ],
            });

            cy.get(box.treeItem.linkSelector).click();
            cy.get(boxForm.formTabs.getTab('Resources')).click();

            box.form.check({
               layers: [
                  {
                     order: 1,
                     item: { id: defaultOS[1].title },
                  },
                  {
                     order: 2,
                     item: {
                        id: SIMPLE_HTTP_SERVER_LAYER_ID,
                     },
                  },
               ],
            });

            cy.get(sel(dataTest('Layer:1:URL')))
               .contains('div', defaultOS[1].value)
               .should('exist');

            cy.get(sel(dataTest('Layer:2:URL')))
               .contains('div', SIMPLE_HTTP_SERVER_LAYER_URL)
               .should('exist');

            cy.get(sel(dataTest('Layer:1:Link')))
               .contains('a', 'PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP')
               .should('exist');

            cy.get(sel(dataTest('Layer:2:Link')))
               .contains('a', 'OTHER_RESOURCE')
               .should('exist');

            cy.get(sel(dataTest('Layer:1:Checksum')))
               .contains('div', 'EMPTY:')
               .should('exist');

            cy.get(sel(dataTest('Layer:2:Checksum')))
               .contains('div', SIMPLE_HTTP_SERVER_LAYER_CHECKSUM)
               .should('exist');
         });

         if (SERVICE === SERVICES.BACKEND) {
            stageStatusPage.stageReadyAfterSave('2');
         }
      });
   });
});
