import { YCSuggestField } from 'page_objects/components';
import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { getStageName, TIMEOUTS } from '../../../../utils';

context('StageFormFocus', () => {
   const stageName = getStageName('stage-form-focus');
   const deployUnitName = 'deployUnit';

   const stageEditPage = new StageEditPage(stageName);

   const deployUnitEdit = stageEditPage.hugeForm.deployUnit(deployUnitName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Edit form should keep focus', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageEditPage.visit();

         cy.get(deployUnitEdit.treeItem.linkSelector).click();

         const networkField = deployUnitEdit.form.fields.network as YCSuggestField;
         networkField.getInput().focus();

         // достаточно долгое время, чтобы проверить любой лишний ререндер
         cy.wait(TIMEOUTS.waitFormStableRender);

         // фокус должен сохранится
         networkField.getInput().focused();

         cy.log('фокус не сброшен');
      });
   });
});
