import { dataE2E, DEFAULT_PROJECT, getStageName, sel } from '../../../../utils';

import { StageConfigPage } from '../../../../page_objects/stage/StageConfigPage';
import { StageEditPage } from '../../../../page_objects/stage/StageEditPage';

const infra = {
   service: {
      name: 'Infracloudui',
      id: 2178,
   },
   environment: {
      name: 'e2e',
      id: 5066,
   },
};

context('InfraSet', () => {
   const stageName = getStageName('edit_settings');
   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should set and delete infra settings', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageEditPage.visit();

         // set infra settings
         stageEditPage.hugeForm.stageForm.form.set({
            infra: {
               service: infra.service.name,
               environment: infra.environment.name,
            },
         });

         stageEditPage.deploy();

         // check infra settings
         [stageConfigPage, stageEditPage].map((page, pageIndex) => {
            page.visit();

            const stageForm = page.hugeForm.stageForm;

            cy.get(stageForm.treeItem.linkSelector).click();

            stageForm.form.check({
               id: stageName,
               project: DEFAULT_PROJECT,
               infra: {
                  service: infra.service.name,
                  environment: infra.environment.name,
               },
               sox: false,
            });

            cy.get(sel(dataE2E('Infra:Service')))
               .contains(
                  'a',
                  pageIndex === 0 ? `${infra.service.name} (id: ${infra.service.id})` : `id: ${infra.service.id}`,
               )
               .should('exist');

            cy.get(sel(dataE2E('Infra:Environment')))
               .contains(
                  pageIndex === 0
                     ? `${infra.environment.name} (id: ${infra.environment.id})`
                     : `id: ${infra.environment.id}`,
               )
               .should('exist');
         });

         // clear infra settings, set sox enabled
         stageEditPage.hugeForm.stageForm.form.set({
            infra: {
               environment: '', // удаляем первым, чтобы оба селекта проверить
               service: '',
            },
            sox: true,
         });
         stageEditPage.deploy();

         // check empty infra settings, sox enabled
         [stageConfigPage, stageEditPage].map(page => {
            page.visit();

            page.hugeForm.stageForm.form.check({
               id: stageName,
               infra: {
                  service: '',
                  environment: '',
               },
               project: DEFAULT_PROJECT,
               sox: true,
            });

            cy.get(sel(dataE2E('Infra:Service')))
               .contains('a', 'id:')
               .should('not.exist');

            cy.get(sel(dataE2E('Infra:Environment')))
               .contains('id:')
               .should('not.exist');
         });
      });
   });
});
