import { getStageName, SERVICE, SERVICES } from '../../../../utils';

import { StageConfigPage } from 'page_objects/stage/StageConfigPage';
import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageStatusPage } from 'page_objects/stage/StageStatusPage';
import {
   ProbeMode,
   WorkloadCommandsFormValue,
} from 'page_objects/stage/internal/levels/workload/fields/WorkloadCommandsForm';

const RUN = 'export CONSOLE_ENV=ext-test; cd /opt/app; /usr/bin/supervisord -c /etc/supervisor/supervisord.conf';

const commands: WorkloadCommandsFormValue = {
   start: {
      command: '/bin/bash /run.sh',
      // проставляем вручную, т.к. надо расхлопывать настройки
      // advanced: {
      //    access: {
      //       user: 'user',
      //       group: 'user',
      //    }
      // }
   },

   init: [
      {
         order: 1,
         command: `bash -c 'printf "${RUN}" > ./run.sh'`,
      },
      {
         order: 2,
         command: `bash -c 'printf "init test" > ./init-test'`,
      },
   ],

   liveness: {
      // mode: ProbeMode.HTTP,
      http: {
         path: '/',
         port: '80',
         answer: {
            expected: 'answer\n',
            // any: true,
         },
      },
   },

   readiness: {
      // mode: ProbeMode.HTTP,
      http: {
         path: '/',
         port: '80',
         answer: {
            // expected: 'answer',
            any: true,
         },
      },
   },

   stop: {
      maxTries: '1',
      exec: {
         command: 'stop',
      },
   },

   destroy: {
      maxTries: '2',
      exec: {
         command: 'destroy',
      },
   },
};

context('WorkloadCommands', () => {
   const stageName = getStageName('workload_commands');

   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);
   const stageStatusPage = new StageStatusPage(stageName);

   const workloadForm = stageEditPage.hugeForm.workload('deployUnit', 'box', 'workload');

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('should edit workload commands', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageEditPage.visit();

         cy.get(workloadForm.treeItem.linkSelector).click();

         // TODO: разобраться, почему не работает
         // check logs
         // workloadForm.form.check({
         //    logs: true,
         // });

         /**
          *  проверяем начальные
          */

         // check start
         workloadForm.form.check({
            commands: [
               {
                  start: {
                     command: `/simple_http_server 80 'Hello my dear @khoden!'`,
                  },
               },
               {
                  start: {
                     advanced: {
                        show: true,
                     },
                  },
               },
               {
                  start: {
                     advanced: {
                        access: {
                           user: '',
                           group: '',
                        },
                     },
                  },
               },
               {
                  start: {
                     advanced: {
                        hide: true,
                     },
                  },
               },
            ],
         });

         // check empty init
         workloadForm.form.check({
            commands: [
               {
                  init: [
                     {
                        order: 1,
                        command: '',
                     },
                  ],
               },
            ],
         });

         // check default readiness
         workloadForm.form.check({
            commands: [
               {
                  readiness: {
                     mode: ProbeMode.TCP,
                     tcp: {
                        port: '80',
                     },
                  },
               },
            ],
         });

         // check empty liveness
         workloadForm.form.check({
            commands: [
               {
                  liveness: {
                     mode: ProbeMode.TCP,
                     tcp: {
                        port: '',
                     },
                  },
               },
            ],
         });

         // check empty stop
         workloadForm.form.check({
            commands: [
               {
                  stop: {
                     mode: ProbeMode.EXEC,
                     exec: {
                        command: '',
                     },
                     maxTries: '',
                  },
               },
            ],
         });

         // check empty destroy
         workloadForm.form.check({
            commands: [
               {
                  destroy: {
                     mode: ProbeMode.EXEC,
                     exec: {
                        command: '',
                     },
                     maxTries: '',
                  },
               },
            ],
         });

         /**
          *  устанавливаем значения
          */

         workloadForm.form.set({
            commands: [
               {
                  init: [
                     {
                        order: 2,
                        add: true,
                     },
                     {
                        order: 3,
                        add: true,
                     },
                     {
                        order: 3,
                        remove: true,
                     },
                  ],
               },
               {
                  liveness: {
                     mode: ProbeMode.EXEC,
                     exec: {
                        command: 'command',
                     },
                  },
               },
               {
                  liveness: {
                     mode: ProbeMode.TCP,
                     tcp: {
                        port: '80',
                     },
                  },
               },
               {
                  liveness: {
                     mode: ProbeMode.HTTP,
                  },
               },
               {
                  readiness: {
                     mode: ProbeMode.EXEC,
                     exec: {
                        command: 'command',
                     },
                  },
               },
               {
                  readiness: {
                     mode: ProbeMode.TCP,
                     // tcp: {
                     //    port: '80',
                     // },
                  },
               },
               {
                  readiness: {
                     mode: ProbeMode.HTTP,
                     // tcp: {
                     //    port: '80',
                     // },
                  },
               },
            ],
         });

         workloadForm.form.set({
            commands: [commands],
         });

         workloadForm.form.set({
            commands: [
               {
                  start: {
                     advanced: {
                        show: true,
                     },
                  },
               },
               {
                  start: {
                     advanced: {
                        access: {
                           user: 'user',
                           group: 'group',
                        },
                     },
                  },
               },
               // {
               //    start: {
               //       advanced: {
               //          hide: true,
               //       },
               //    },
               // },
            ],
         });

         stageEditPage.deploy();

         // check new form/config values
         [stageConfigPage, stageEditPage].map((page, pageIndex) => {
            page.visit();

            const workload = page.hugeForm.workload('deployUnit', 'box', 'workload');

            cy.get(workload.treeItem.linkSelector).click();

            workload.form.check({
               commands: [
                  {
                     start: commands.start,
                  },
                  {
                     start: {
                        advanced: {
                           // проверяем, что настройки открыты
                           hide: true,
                        },
                     },
                  },
                  {
                     start: {
                        advanced: {
                           show: true,
                        },
                     },
                  },
                  {
                     start: {
                        advanced: {
                           access: {
                              user: 'user',
                              group: 'group',
                           },
                        },
                     },
                  },
                  {
                     init: commands.init,

                     liveness: {
                        ...commands.liveness,
                        mode: pageIndex === 0 ? undefined : commands.liveness.mode, // TODO: решить проблему с YCRadioField readonly (title !== value)
                     },

                     readiness: {
                        ...commands.readiness,
                        mode: pageIndex === 0 ? undefined : commands.readiness.mode, // TODO: решить проблему с YCRadioField readonly (title !== value)
                     },
                  },
               ],
            });

            if (pageIndex === 1) {
               // просто переключаем режимы
               workload.form.set({
                  commands: [
                     {
                        liveness: {
                           mode: ProbeMode.EXEC,
                        },
                     },
                     {
                        liveness: {
                           mode: ProbeMode.TCP,
                        },
                     },
                     {
                        liveness: {
                           mode: ProbeMode.HTTP,
                        },
                     },
                     {
                        readiness: {
                           mode: ProbeMode.EXEC,
                        },
                     },
                     {
                        readiness: {
                           mode: ProbeMode.TCP,
                        },
                     },
                     {
                        readiness: {
                           mode: ProbeMode.HTTP,
                        },
                     },
                  ],
               });

               // проверяем, что сохранились значения
               workload.form.check({
                  commands: [
                     {
                        liveness: commands.liveness,
                        readiness: commands.readiness,
                     },
                  ],
               });
            }
         });

         if (SERVICE === SERVICES.BACKEND) {
            stageStatusPage.stageReadyAfterSave('2');
         }
      });
   });
});
