import { dataE2E, fieldControl, sel } from '../../utils';

import { BaseForm } from '../stage/internal/levels/BaseForm';
import { TextInputField, TextInputFieldValue } from './fields';

export interface ApprovalPolicyFormValue {
   count: TextInputFieldValue;
}

export class ApprovalPolicyForm extends BaseForm<ApprovalPolicyFormValue> {
   displayName = 'ApprovalPolicyForm';

   public body = dataE2E('ApprovalPolicy:Form');

   public wrapper = this.body;

   public fields = {
      count: new TextInputField(sel(this.body, fieldControl('count'))),
   };
}
