import { dataE2E } from '../../utils';
import { ApprovalPolicyForm } from './ApprovalPolicyForm';
import { ModalLayout } from './internal/ModalLayout';

export class ApprovalPolicyModal extends ModalLayout {
   public actions = {
      init: this.getApprovalAction('InitCreating'),
      create: this.getApprovalAction('Create'),
      update: this.getApprovalAction('Update'),
      delete: this.getApprovalAction('Delete'),
      confirmDeleting: this.getApprovalAction('ConfirmDeleting'),
      confirmUpdating: this.getApprovalAction('ConfirmUpdating'),
   };

   public form = new ApprovalPolicyForm();

   private getApprovalAction(name) {
      return dataE2E(`ApprovalPolicy:${name}`);
   }

   public fillSimpleApprovalPolicy() {
      cy.get(this.actions.init).click();
      this.form.set({
         count: '1',
      });
      cy.get(this.actions.create).click();
      cy.get(this.closeButton).click();
   }
}
