import { dataE2E, fieldControl, sel } from '../../utils';
import { TextAreaField } from './fields';

export class DeployTicket {
   public actions = {
      approve: this.getTicketAction('approve'),
      disapprove: this.getTicketAction('disapprove'),
      commit: this.getTicketAction('commit'),
      skip: this.getTicketAction('commit'),
   };

   public status = dataE2E('Ticket:Status');

   private body = dataE2E('Ticket:Body');

   public buttons = {
      approve: dataE2E('DeployTicket:Approve'),
      disapprove: dataE2E('DeployTicket:Disapprove'),
      commit: dataE2E('DeployTicket:Commit'),
      skip: dataE2E('DeployTicket:Skip'),
      actions: dataE2E('DeployTicket:Actions'),
   };

   private getTicketAction(name) {
      return () => {
         cy.get(this.buttons[name]).click();

         const modalSel = dataE2E('Ticket:ActionModal');
         cy.get(modalSel);
         const textInput = new TextAreaField(sel(modalSel, fieldControl('message')));
         textInput.set(`cypress ${name}`);
         cy.get(sel(modalSel, 'button[type="submit"]')).click();
      };
   }
}
