import { dataTest, sel, Selector } from '../../utils';

export class JsonCustom {
   constructor(public selector: Selector) {}

   public wrapper = sel(this.selector, dataTest('json-custom'));

   public check(jsonText: string) {
      cy.get(this.wrapper).invoke('text').then(text => {
         expect(text.replace(/\s+/g, '')).to.be.eq(jsonText.replace(/\s+/g, ''));
      })
   }

}
