import { dataE2E, sel, TIMEOUTS } from '../../utils';

export class ReleaseRulePopup {
   public wrapper = dataE2E('ReleaseRule:Select');

   public actions = {
      newSandboxRule: this.getCreateRuleButton('Sandbox'),
      newDockerRule: this.getCreateRuleButton('Docker'),
   };

   public getCreateRuleButton(name: 'Sandbox' | 'Docker') {
      return function () {
         // пропадает кнопка из селекта https://st.yandex-team.ru/DEPLOY-5434
         cy.get(sel('.yc-popup.yc-popup_open', 'a'), { timeout: TIMEOUTS.superSlow })
            .contains(`New ${name} rule`)
            .parent('a')
            .click();
      };
   }
}
