import { dataQa, fieldControl, sel, testCss } from '../../utils';
import { TextInputField, YCSelectField } from './fields';
import { ModalLayout } from './internal/ModalLayout';

class AddSecretModal extends ModalLayout {
   public secretField = new YCSelectField(sel(this.wrapper, fieldControl('secretUuid', '.yc-select-control')), {
      showSearch: true,
   });

   public version = new YCSelectField(sel(this.wrapper, fieldControl('versionUuid', '.yc-select-control')));

   public alias = new TextInputField(sel(this.wrapper, fieldControl('alias', '.textinput')));

   public okButton = dataQa('AddSecretModal:AddButton');

   public cancelButton = dataQa('AddSecretModal:CancelButton');

   public selectSecret(name: string) {
      this.secretField.set(name);
   }

   public ok() {
      cy.get(this.okButton).should('be.visible').should('not.be.disabled').click();
   }
}

export class SecretSubForm {
   public buttons = {
      add: dataQa('SecretSubForm:AddVersion'),
      cancel: dataQa('SecretSubForm:ClearUnused'),
   };

   public fields = {
      secret: new YCSelectField(sel(this.selector, testCss('SecretSubForm-version'))),
      key: new YCSelectField(sel(this.selector, testCss('SecretSubForm-key'))),
   };

   private addSecretModal = new AddSecretModal();

   constructor(private selector: string) {}

   public addNewSecret(name: string) {
      cy.get(this.selector).find(this.buttons.add).click();

      cy.get(this.addSecretModal.wrapper).should('be.visible');
      this.addSecretModal.selectSecret(name);
      cy.wait(1000); // TODO check version selected
      this.addSecretModal.ok();
      cy.get(this.addSecretModal.wrapper).should('not.exist');
   }

   public selectKey(key: string) {
      this.fields.key.set(key);
   }
}
