import { TIMEOUTS } from '../../utils';

import { ModalLayout } from './internal/ModalLayout';

export class ValidationModal extends ModalLayout {
   public constructor(public selector?: string) {
      super();
   }

   public cancel() {
      cy.log('Validation modal: cancel');
      cy.get(this.cancelButton, { timeout: TIMEOUTS.superSlow }).click();
   }

   public close() {
      cy.log('Validation modal: close');
      // cy.wait(15000);
      cy.get(this.cancelButton, { timeout: TIMEOUTS.superSlow }).click();
   }

   public ignoreDiff() {
      cy.log('Validation modal: ignore');
      cy.get(this.okButton, { timeout: TIMEOUTS.superSlow }).click();
   }
}
