/**
 * Checkbox из lego-on-react
 *
 * Ожидает передачу селектора на верхний элемент чекбокса (.checkbox)
 */
import { FormField } from './FormField';

export class CheckboxField implements FormField<boolean> {
   constructor(private selector: string) {}

   public getInput() {
      return cy.get(this.selector, { log: false }).should('be.visible').find('input');
   }

   public check(v: boolean) {
      if (v) {
         this.getInput().should('be.checked');
      } else {
         this.getInput().should('not.be.checked');
      }
   }

   public set(v: boolean) {
      cy.log(`Set CheckboxField value: ${v ? 'true' : 'false'}`);

      if (v) {
         this.getInput().should('not.be.checked').click().should('be.checked');
      } else {
         this.getInput().should('be.checked').click().should('not.be.checked');
      }
   }
}
