import { sel } from '../../../utils';

import { FormField } from './FormField';
import { TextInputField } from './TextInputField';

// не используется?
export class CheckboxListField implements FormField<string[]> {
   private button = sel(this.selector, 'button');

   private popup = '.popup2';

   private searchInput = new TextInputField(sel(this.popup, '.yc-select-search', '.textinput'));

   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return this.searchInput.getInput();
   }

   public check(v: string[]) {
      // TODO
      throw new Error('TODO CheckboxListField check');
   }

   public set(v: string[]) {
      cy.log(`Set CheckboxListField value: ${v.join(', ')}`);

      cy.get(this.button).click();

      v.forEach(element => {
         cy.get(this.popup).find('label').contains(element).click();
      });

      cy.get(this.button).click();
   }
}
