import { EnumField } from './EnumField';
import { FormField } from './FormField';

export type EnabledSwitcherFieldValue = boolean;

/**
 * Enabled/Disabled компонент
 */
export class EnabledSwitcherField implements FormField<EnabledSwitcherFieldValue> {
   private enumSwitcher = new EnumField<'enabled' | 'disabled'>(this.selector);

   constructor(private selector: string) {}

   public getInput() {
      return this.enumSwitcher.getInput();
   }

   public async check(v: boolean, options?: { readonly: boolean }) {
      if (options?.readonly) {
         cy.get(this.selector)
            .contains(v ? 'Enabled' : 'Disabled')
            .should('exist');
      } else {
         await this.enumSwitcher.check(v ? 'enabled' : 'disabled', options);
      }
   }

   public async set(v: boolean) {
      cy.log(`Set EnabledSwitcherField value: ${v ? 'enabled' : 'disabled'}`);

      await this.enumSwitcher.set(v ? 'enabled' : 'disabled');
   }
}
