import { FormField } from './FormField';

/**
 * <EnumField2> from infracloud-ui/libs
 */
export class EnumField<V extends string> implements FormField<string> {
   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return cy.get(this.selector).find('input');
   }

   public check(v: V, options?: { readonly: boolean }) {
      cy.log(`Check EnumField value: ${v}`);

      if (options?.readonly) {
         cy.log(`readonly: ${options.readonly}`);

         this.getInput().should('exist').should('be.hidden').should('have.value', v);
      } else {
         this.getInput().filter(`[value="${v}"]`).should('be.checked');
      }
   }

   public set(v: V) {
      cy.log(`Set EnumField value: ${v}`);

      this.getInput()
         .filter(`[value="${v}"]`)
         .then($input => {
            $input.trigger('click');
         });
   }
}
