import { TIMEOUTS } from '../../../utils';

type WaitForHideParams = {
   timeout?: number, // in ms
}

export class Loader {
   constructor(public selector: string) {
   }

   public shouldBeVisible() {
      cy.get(this.selector).should('be.visible');
   }

   public waitForHide(params?: WaitForHideParams) {
      cy.get(this.selector, {timeout: params?.timeout ?? TIMEOUTS.slow}).should('not.exist');
   }
}
