import { EMPTY_VALUE } from 'utils';

import { FormField } from './FormField';

export class TextAreaField implements FormField<string> {
   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery<HTMLTextAreaElement>> {
      return cy.get(this.selector).find('textarea');
   }

   public check(v: string, options?: { readonly: boolean }): void {
      cy.log(`Check TextAreaField value: ${v === '' ? '(empty)' : v}`);

      if (options?.readonly) {
         cy.log(`readonly: ${options.readonly}`);

         cy.get(this.selector)
            .contains('pre', v === '' ? EMPTY_VALUE : v)
            .should('exist');
      } else {
         if (v === '') {
            this.getInput().should('be.empty');
         } else {
            this.getInput().should('have.value', v);
         }
      }
   }

   public set(v: string) {
      cy.log(`Set TextAreaField value: ${v}`);

      const clearInput = this.getInput().should('be.visible').should('not.be.disabled').scrollIntoView().clear();

      if (v) {
         clearInput.type(v, { parseSpecialCharSequences: false, delay: 0 });
      }

      clearInput.should('have.value', v);
   }
}
