import { EMPTY_VALUE, TIMEOUTS } from '../../../utils';

import { FormField } from './FormField';

export type TextInputFieldValue = string;

export class TextInputField implements FormField<TextInputFieldValue> {
   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery<HTMLInputElement>> {
      return cy.get(this.selector, { timeout: TIMEOUTS.fast }).find('input');
   }

   public check(v: string, options?: { readonly: boolean }): void {
      cy.log(`Check TextInputField value: ${v === '' ? '(empty)' : v}`);

      if (options?.readonly) {
         cy.log(`readonly: ${options.readonly}`);

         cy.get(this.selector)
            .contains('div', v === '' ? EMPTY_VALUE : v)
            .should('exist');
      } else {
         if (v === '') {
            this.getInput().should('be.empty');
         } else {
            this.getInput().should('have.value', v);
         }
      }
   }

   public set(v: string) {
      cy.log(`Set TextInputField value: ${v}`);

      const clearInput = this.getInput().should('be.visible').should('not.be.disabled').scrollIntoView().clear();

      if (v) {
         clearInput.type(v, { parseSpecialCharSequences: false, delay: 0 });
      }

      clearInput.should('have.value', v);
   }

   public clear() {
      cy.log('Clear TextInputField value');

      this.set('');
   }

   // public setFixed(v: string) {
   //    // не получается "напечатать" текст, валится с ошибкой:
   //    //  то "detached DOM-element", то "disabled"
   //    // Воспроизводится ошибка только в форме в electron
   //    this.getInput().then(input$ => {
   //       input$.val(v);
   //       cy.log('Set value', v);
   //    });
   // }
}
