import { EnumField } from './EnumField';
import { FormField } from './FormField';

/**
 * @deprecated  use <Switch> from data-ui/common
 */
export class TumblerField implements FormField<boolean> {
   private enumSwitcher = new EnumField<'true' | 'false'>(this.selector);

   constructor(private selector: string) {}

   public getInput() {
      return this.enumSwitcher.getInput();
   }

   public check(v: boolean) {
      // TODO
      throw new Error('TODO TumblerField check');
   }

   public set(v: boolean) {
      cy.log(`Set TumblerField value: ${v ? 'true' : 'false'}`);

      // Данные инвертированы, так как необходим клик по текущему положению тумблера
      this.enumSwitcher.set(v ? 'false' : 'true');
   }
}
