import { sel } from '../../../utils';
import { BaseFormField } from './FormField';

export type YCDropdownFieldValue = string;

export class YCDropdownField<V extends string> implements BaseFormField<YCDropdownFieldValue> {
   constructor(public selector: string) {
   }

   public wrapper = sel(this.selector, '.yc-dropdown-menu__switcher-wrapper');

   public text = sel(this.wrapper, '.yc-button__text');

   public popup = sel('.yc-popup.yc-popup_open', '.yc-menu');

   public check(v: YCDropdownFieldValue): void {
      cy.get(this.text).should('have.text', v);
   }

   public set(v: YCDropdownFieldValue): void {
      cy.get(this.wrapper).click();
      cy.get(this.popup).should('be.visible').get('.yc-dropdown-menu__menu-item').contains(v).click();
   }

}
