import { sel } from '../../../utils';
import { FormField } from './FormField';

/**
 * <RadioButton> from data-ui/common
 */
export class YCRadioField<V extends string> implements FormField<string> {
   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return cy.get(this.selector).should('be.visible').find('input[type="radio"]');
   }

   public check(v: V, options?: { readonly: boolean }) {
      cy.log(`Check YCRadioField value: ${v}`);

      if (options?.readonly) {
         throw new Error('TODO: решить проблему с readonly в разных компонентах (title !== value)');
      } else {
         this.getInput().filter(`[value="${v}"]`).should('be.checked');
      }
   }

   public set(v: V) {
      cy.log(`Set YCRadioField value: ${v}`);

      this.getInput().filter(`[value="${v}"]`).click();
   }

   private textSelector = '.radio-button__text'; // main text + meta text
   private metaSelector = sel(this.textSelector, '.radio-button__radio-meta'); // meta text only

   public getText = (v: V, options?: Cypress.Timeoutable) =>
      this.getInput().filter(`[value="${v}"]`).parent('label').find(this.textSelector, options);
   public getMeta = (v: V, options?: Cypress.Timeoutable) =>
      this.getInput().filter(`[value="${v}"]`).parent('label').find(this.metaSelector, options);

   public haveValues(vs: V[]) {
      this.getInput().its('length').should('eq', vs.length);

      for (const v of vs) {
         this.getInput().filter(`[value="${v}"]`).should('exist');
      }
   }
}
