import { EMPTY_VALUE, sel } from '../../../utils';

import { FormField } from './FormField';
import { TextInputField } from './TextInputField';

export type YCSelectFieldValue = string;

export type YCSelectFieldOptions = Partial<{ showSearch: boolean }>;

export class YCSelectField implements FormField<YCSelectFieldValue> {
   public switcher = sel(this.selector, '.yc-select-control__tokens-text');

   private popup = sel('.yc-popup.yc-popup_open');

   private searchInput = new TextInputField(sel(this.popup, '.yc-select-search', '.yc-text-input'));

   constructor(private selector: string, private options?: YCSelectFieldOptions) {}

   public clear() {
      cy.get(this.switcher).click();
      cy.get(sel(this.popup, '.yc-button')).click();
   }

   public getInput(): Cypress.Chainable<JQuery> {
      return this.searchInput.getInput();
   }

   public check(v: YCSelectFieldValue, options?: { readonly: boolean }): void {
      cy.log(`Check YCSelectField value: ${v === '' ? '(empty)' : v}`);

      if (options?.readonly) {
         cy.log(`readonly: ${options.readonly}`);

         cy.get(this.selector)
            .contains(v === '' ? EMPTY_VALUE : v)
            .should('exist');
      } else {
         if (v === '') {
            cy.get(sel(this.selector, '.yc-select-control__tokens-text_empty')).should('exist');
         } else {
            cy.get(this.switcher).contains(v).should('exist');
         }
      }
   }

   public set(v: YCSelectFieldValue) {
      cy.log(`Set YCSelectField value: ${v}`);

      if (v === '') {
         this.clear();

         return;
      }

      cy.get(this.switcher).scrollIntoView().click();

      if (this.options?.showSearch) {
         this.searchInput.set(v);
      }

      cy.get(this.popup).find('.yc-select-item__title').contains(v).click();
   }
}
