import { sel } from '../../../utils';

import { FormField } from './FormField';
import { TextInputField } from './TextInputField';
import { YCSelectFieldOptions } from './YCSelectField';

export type YCSelectMultipleFieldValue = string[];

export type YCSelectMultipleFieldOptions = YCSelectFieldOptions;

export class YCSelectMultipleField implements FormField<YCSelectMultipleFieldValue> {
   public switcher = sel(this.selector, '.yc-select-control__tokens-text');

   private popup = '.yc-select-popup';

   private searchInput = new TextInputField(sel(this.popup, '.yc-select-search', '.yc-text-input'));

   constructor(private selector: string, private options?: YCSelectMultipleFieldOptions) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return this.searchInput.getInput();
   }

   public check(v: YCSelectMultipleFieldValue) {
      // TODO
      throw new Error('TODO YCSelectMultipleField check');
   }

   public set(v: YCSelectMultipleFieldValue) {
      cy.log(`Set YCSelectMultipleField value: ${v.join(', ')}`);

      cy.get(this.switcher).click();

      v.forEach(element => {
         if (this.options?.showSearch) {
            this.searchInput.set(element);
         }

         cy.get(this.popup).find('.yc-select-item__title').contains(element).click();
      });

      cy.get(this.switcher).contains(v.sort().join(', ')).click();
   }
}
