import { sel, Selector, TIMEOUTS } from '../../../utils';

import { FormField } from './FormField';

export type YCSuggestFieldValue = string;

export class YCSuggestField implements FormField<string> {
   private input = sel(this.selector, 'input');

   private popup = '.yc-suggest__popup'; // TODO .filterVisible();

   private itemList = sel(this.popup, '.yc-suggest__list');

   constructor(private selector: Selector) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return cy.get(this.input, { log: false });
   }

   public check(v: YCSuggestFieldValue) {
      // TODO
      throw new Error('TODO YCSuggestField check');
   }

   public async set(v: YCSuggestFieldValue) {
      cy.log(`Set YCSuggestField value: ${v}`);

      this.getInput().type(v);

      cy.get(this.itemList, { timeout: TIMEOUTS.superSlow }).should('be.visible');

      // cy.wait(TIMEOUTS.fast);
      // AssertionError: Timed out retrying after 30000ms: Expected to find element: `.yc-suggest__popup .yc-suggest__list .yc-suggest__item div`, but never found it.
      cy.get(sel(this.itemList, '.yc-suggest__item', 'div'), { timeout: TIMEOUTS.api.suggest })
         .contains(v, { timeout: TIMEOUTS.api.suggest })
         .click();
   }
}
