import { FormField } from './FormField';

export class YCSwitchField<V extends boolean> implements FormField<boolean> {
   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return cy.get(this.selector).find('input');
   }

   public check(v: V) {
      // TODO
      throw new Error('TODO YCSwitchField check');
   }

   public set(v: V) {
      cy.log(`Set YCSwitchField value: ${v ? 'on' : 'off'}`);

      this.getInput()
         // Данные инвертированы, так как необходим клик по компоненту с текущим значением
         .filter(`[aria-checked="${v ? 'false' : 'true'}"]`)
         .then($input => {
            $input.trigger('click');
         });
   }
}
