import { sel, TIMEOUTS } from '../../../../utils';
import { FormField } from '../FormField';

/**
 * используется при создании проекта
 */
export class FormFieldSuggest implements FormField<string> {
   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery<HTMLInputElement>> {
      return cy.get(this.selector).find('input');
   }

   public check(v: string): void {
      cy.log(`Check FormFieldSuggest value: ${v === '' ? '(empty)' : v}`);

      if (v === '') {
         this.getInput().should('be.empty');
      } else {
         this.getInput().should('have.value', v);
      }
   }

   public set(v: string) {
      // "Правильный" вариант
      this.getInput()
         .should('not.be.disabled')
         .type('{selectall}' + v)
         .should('have.value', v)
         .then(() => {
            cy.get(sel(this.selector, `.scrollable-list__item[aria-label="${v}"]`), { timeout: TIMEOUTS.api.suggest })
               .should('be.visible')
               .click();
         });
   }
}
