import { dataTest, sel } from '../../utils';

import { CheckboxField, FormFieldSuggest, TextInputField } from '../components';

export interface CreateFormParams {
   name?: string;
   accountId?: string;
   tempAccount?: boolean;
}

export class CreateProjectForm {
   public body = dataTest('project-create-form');

   public fields = {
      name: new TextInputField(sel(dataTest('form-field--project-name'))),
      accountId: new FormFieldSuggest(sel(dataTest('form-field--abc-service'))),
      temporaryAccount: new CheckboxField(sel(dataTest('form-field--use-temporary-account'))),
   };

   public buttons = {
      cancel: dataTest('project-create-form__button_cancel'),
      submit: dataTest('project-create-form__button_submit'),
   };

   public set(value: CreateFormParams) {
      this.apply(value, 'set');
   }

   public check(value: CreateFormParams) {
      this.apply(value, 'check');
   }

   protected apply(v: CreateFormParams, methodName: 'set' | 'check') {
      if (v.name) {
         this.fields.name[methodName](v.name);
      }

      if (v.accountId) {
         this.fields.accountId[methodName](v.accountId);
      }

      if (v.tempAccount !== undefined) {
         this.fields.temporaryAccount[methodName](v.tempAccount);
      }
   }

   public cancel() {
      cy.get(this.body).should('be.visible');
      cy.get(this.buttons.cancel).click();
      cy.get(this.body).should('not.be.visible');
   }

   public submit() {
      cy.get(this.buttons.submit).click();
   }
}
