import { dataTest, ROUTES, sel } from '../../utils';
import { AppLayout } from '../AppLayout';
import { TextInputField, YCRadioField, YCSelectField } from '../components';
import { CreateProjectForm } from './CreateProjectForm';

export class ProjectListPage extends AppLayout {
   public buttons = {
      create: dataTest('create-project-button'),
      reset: dataTest('filter-projects-reset'),
      search: dataTest('filter-projects-search'),
   };

   public pathname = ROUTES.projects();

   public createProjectForm = new CreateProjectForm();

   public bodySelector = dataTest('page-main');

   public selectors = {
      header: sel(this.bodySelector, '.page__header'),
      content: sel(this.bodySelector, dataTest('page-content')),
   };

   public filters = {
      owner: new YCRadioField(dataTest('filter-projects-by-owner')),
      type: new YCSelectField(dataTest('filter-projects-by-type')),
      name: new TextInputField(dataTest('filter-projects-by-name')),
   };

   public notFound = dataTest('EmptyContainer:Content');

   public visit() {
      cy.log(`Project list page: visit`);
      cy.visit(this.pathname);
   }

   public project(name: string) {
      return dataTest(`project--${name}`);
   }

   public stage(name: string) {
      return dataTest(`stage--${name}`);
   }

   public launchNewStage(projectName: string) {
      return sel(this.project(projectName), '.project-card__create-stage-button');
   }
}
