import { dataQa, dataTest, sel } from '../../utils';

import { CheckboxField, FormFieldSuggest, TextInputField } from '../components';

export interface EditFormParams {
   accountId?: string;
   tempAccount?: boolean;
   monitoringProject?: string;
   tags?: string[];
}

export class EditProjectForm {
   public body = dataTest('project-edit-form');

   public fields = {
      accountId: new FormFieldSuggest(sel(dataTest('form-field--abc-service'))),
      temporaryAccount: new CheckboxField(sel(dataTest('form-field--use-temporary-account'))),
      monitoringProject: new FormFieldSuggest(sel(dataTest('form-field--monitoring-project'))),
      tags: new TextInputField(sel(dataTest('form-field--tags'))),
   };

   public buttons = {
      cancel: dataQa('ProjectEditForm:CancelButton'),
      submit: dataQa('ProjectEditForm:SubmitButton'),
   };

   public set(value: EditFormParams) {
      this.apply(value, 'set');
   }

   public check(value: EditFormParams) {
      this.apply(value, 'check');
   }

   protected apply(v: EditFormParams, methodName: 'set' | 'check') {
      if (v.accountId !== undefined) {
         this.fields.accountId[methodName](v.accountId);
      }

      if (v.tempAccount !== undefined) {
         this.fields.temporaryAccount[methodName](v.tempAccount);
      }

      if (v.monitoringProject !== undefined) {
         this.fields.monitoringProject[methodName](v.monitoringProject);
      }

      if (v.tags) {
         if (methodName === 'set') {
            v.tags.forEach(tag => {
               this.fields.tags.getInput().type(`${tag} `);
            });
         }

         if (methodName === 'check') {
            if (v.tags.length === 0) {
               cy.get(this.body).find(dataTest('form-field--tags')).find(dataTest('TagList:Tag')).should('not.exist');
            } else {
               v.tags.forEach(tag => {
                  cy.get(this.body)
                     .find(dataTest('form-field--tags'))
                     .find(dataTest('TagList:Tag'))
                     .contains(tag)
                     .should('exist');
               });
            }
         }
      }
   }

   public cancel() {
      cy.get(this.body).should('exist');
      cy.get(this.buttons.cancel).click();
      cy.get(this.body).should('not.exist');
   }

   public submit() {
      cy.get(this.buttons.submit).click();
   }
}
