import { EditProjectForm } from 'page_objects/project/EditProjectForm';
import { dataTest, ROUTES, sel, TIMEOUTS } from '../../utils';
import { EmptyContainer } from '../components/EmptyContainer';

class DeleteProjectWarning {
   public confirmCheckbox = '.confirm-dialog__confirmation';

   public submitButton = dataTest('action-delete');
}

export class ProjectPage {
   public pathname = ROUTES.project(this.projectName);

   public buttons = {
      editButton: sel(dataTest('project-actions__edit'), 'button'),
      deleteButton: sel(dataTest('project-actions__delete'), 'button'),
   };

   public editProjectForm = new EditProjectForm();

   public deleteWarning = new DeleteProjectWarning();

   public projectTitle = sel('h1.project__title');

   public noAvailableAclMessage = sel('.project__no-available-acl');

   public stageList = sel('.project__stage-list');

   public stageLinks = sel('.stage-roles-card__title a');

   public emptyContainer = new EmptyContainer(this.pathname);

   public visit() {
      cy.log(`Project page: visit ${this.projectName}`);

      cy.visit(this.pathname);
   }

   public checkNotFound() {
      this.visit();

      this.emptyContainer.checkTitle('Project was not found');
   }

   public waitForProjectACL() {
      cy.log('Waiting for project ACL and roles...');

      // AssertionError: Timed out retrying after 10000ms: Expected to find element: `h1.project__title`, but never found it.
      //    at ProjectPage../page_objects/project/ProjectPage.ts.ProjectPage.waitForProjectACL (https://localhost.yandex-team.ru:9000/__cypress/tests?p=integration/userStories/project/ProjectDelete.ts:18178:12)
      //    at Context.eval (https://localhost.yandex-team.ru:9000/__cypress/tests?p=integration/userStories/project/ProjectDelete.ts:177:21)
      cy.get(this.projectTitle, { timeout: TIMEOUTS.api.pageLoading }).contains(this.projectName).should('exist');

      // cy.wait(TIMEOUTS.immediately);

      cy.get(this.noAvailableAclMessage, { timeout: TIMEOUTS.waitProjectAcl }).should('exist');
      cy.get(this.noAvailableAclMessage, { timeout: TIMEOUTS.waitProjectAcl }).should('not.exist');
   }

   constructor(private projectName: string) {}
}
