import {
   dataE2E, DEFAULT_BOX,
   DEFAULT_DEPLOY_UNIT,
   DEFAULT_NETWORK,
   DEFAULT_PROJECT, DEFAULT_WORKLOAD,
   DISABLED_LOCATIONS,
   ROUTES,
   TIMEOUTS,
} from '../../utils';

import { ValidationModal } from 'page_objects/components/ValidationModal';

import { DiffView } from './internal/DiffView';
import { LocationItem } from './internal/levels/deployUnit/fields/LocationCards';
import { StageHugeForm } from './internal/StageHugeForm';
import { StageHugeFormButtons } from './internal/StageHugeFormButtons';
import { StagePatcherOptions } from './internal/StagePatcherOptions';
import { StageQuota } from './internal/StageQuota';

export class NewStagePage {
   // TODO: проекта в новом стейдже может не быть
   // этот pathname покрывает только один кейс
   public pathname = ROUTES.newStage(DEFAULT_PROJECT);

   public buttons = new StageHugeFormButtons();

   public hugeForm = new StageHugeForm(ROUTES.newStage(), false);

   public validationModal = new ValidationModal();

   public stagePatcherOptions = new StagePatcherOptions();

   public diffView = new DiffView();

   public quota = new StageQuota();

   public visit() {
      cy.log('New stage page: visit');
      cy.visit(this.pathname);
      cy.get(dataE2E('HugeForm'), { timeout: TIMEOUTS.slow }).should('be.visible');
   }

   public fillSimpleStage(id?: string) {
      cy.get(this.hugeForm.stageForm.treeItem.linkSelector).click();

      if (id) {
         this.hugeForm.stageForm.form.set({
            id,
            // project: DEFAULT_PROJECT, // не заполняем #DEPLOY-5640
         });
      }

      cy.envConfig().then(envConfig => {
         const locations: LocationItem[] = envConfig.clusters
            .map(cluster => ({
               id: cluster.value,
               enabled: !DISABLED_LOCATIONS.includes(cluster.value), // кроме первого уже выбранного
               podCount: 1,
            })).filter((c, i) =>
               i === 0 ? !c.enabled : c.enabled
            );
         cy.log(locations.map(l => l.id).join(', '));

         const deployUnit = this.hugeForm.deployUnit(DEFAULT_DEPLOY_UNIT);
         cy.get(deployUnit.treeItem.linkSelector).click();
         deployUnit.form.set({
            id: 'myDeployUnit', //
            type: 'multi_cluster_replica_set',
            disruptionBudget: String(locations.length - 1),
            locations,
            network: DEFAULT_NETWORK,
         });
      });

      const workload = this.hugeForm.workload(DEFAULT_DEPLOY_UNIT, DEFAULT_BOX, DEFAULT_WORKLOAD);
      cy.get(workload.treeItem.linkSelector).click();
      workload.form.set({
         logs: false,
      });
   }

   // public revertChanges() {
   //    cy.log('Revert form changes')
   //    cy.get(this.buttons.reset).click();
   // }

   public showUpdates() {
      cy.log('New stage page: show updates');
      this.buttons.update.scrollIntoView().click();
      cy.get(this.stagePatcherOptions.wrapper).should('be.visible');
   }

   public showDiff() {
      cy.log('New stage page: show diff');
      this.buttons.update.scrollIntoView().click();
      cy.get(this.diffView.wrapper).should('be.visible');
   }

   // public closeDiff() {
   //    this.diffView.close();
   // }

   // public closeValidationModal() {
   //    this.validationModal.close();
   // }

   public deploy(description: string) {
      this.showDiff();

      this.diffView.deploy(description);
   }
}
