import { dataTest, ROUTES, TIMEOUTS } from '../../utils';

import { StageButtons } from './internal/StageButtons';
import { StageHugeForm } from './internal/StageHugeForm';
import { StageQuota } from './internal/StageQuota';

import { StageTabPage } from './StageTabPage';

export class StageConfigPage implements StageTabPage {
   public body = dataTest('StageConfigPage');

   public pathname = ROUTES.stageConfig(this.stageName);

   public buttons = new StageButtons();

   public hugeForm = new StageHugeForm(ROUTES.stageConfig(this.stageName), true);

   public quota = new StageQuota();

   constructor(private stageName: string) {}

   public visit() {
      cy.log(`Stage config page: visit ${this.stageName}`);
      cy.visit(this.pathname);
      cy.get(this.body, { timeout: TIMEOUTS.slow }).should('be.visible');
   }
}
