import { dataE2E, dataTest, ROUTES } from '../../utils';

import { ApprovalPolicyModal } from '../components/ApprovalPolicyPopup';
import { DeployTicket } from '../components/DeployTicket';
import { ReleaseRulePopup } from '../components/ReleaseRulePopup';
import { StageReleaseRulePage } from './StageReleaseRulePage';

import { StageTabPage } from './StageTabPage';

export class StageDeployTicketsPage implements StageTabPage {
   public body = dataE2E('Tickets:Body');

   public pathname = ROUTES.stageDeployTickets(this.stageName);

   public buttons = {
      approvalPolicy: dataE2E('ApprovalPolicy:Tooltip'),
      forceRefresh: dataTest('force-refresh'),
      // reset
      // skip selected
   };

   public releaseRulePopup = new ReleaseRulePopup();

   public releaseRule = new StageReleaseRulePage(this.stageName);

   public approvalPolicy = new ApprovalPolicyModal();

   public ticketsList = dataTest('deploy-tickets-list');

   public ticketCreationDate = dataTest('creationDate');

   public row = dataTest('DeployTicket:Row');

   public loadMoreLink = `${dataTest('load-more-tickets')} span`;

   public ticket = new DeployTicket();

   constructor(private stageName: string) {}
}
