import { dataE2E, ROUTES, TIMEOUTS } from '../../utils';

import { ValidationModal } from 'page_objects/components/ValidationModal';
import { DiffView } from './internal/DiffView';
import { StageHugeForm } from './internal/StageHugeForm';
import { StageQuota } from './internal/StageQuota';
import { StageHugeFormButtons } from './internal/StageHugeFormButtons';
import { StagePatcherOptions } from './internal/StagePatcherOptions';

export class StageEditPage {
   public body = dataE2E('StageIndexPage:content');

   public pathname = ROUTES.stageEdit(this.stageName);

   constructor(private stageName: string) {}

   public buttons = new StageHugeFormButtons();

   public hugeForm = new StageHugeForm(ROUTES.stageEdit(this.stageName), false);

   public validationModal = new ValidationModal();

   public stagePatcherOptions = new StagePatcherOptions();

   public diffView = new DiffView();

   public quota = new StageQuota();

   public visit() {
      cy.log(`Stage edit page: visit ${this.pathname}`);
      cy.visit(this.pathname);
      cy.get(this.body, { timeout: TIMEOUTS.superSlow }).should('be.visible');
   }

   // form.revert button

   public revertChanges() {
      cy.log('Stage edit page: revert form changes');
      this.buttons.reset.scrollIntoView().click();
   }

   // form.update buttons

   public showValidationModal() {
      cy.log('Stage edit page: show validation modal');
      this.buttons.update.scrollIntoView().click();
      cy.get(this.validationModal.wrapper).should('be.visible');
   }

   public showDiff() {
      cy.log('Stage edit page: show diff');
      this.buttons.update.scrollIntoView().click();
      cy.get(this.diffView.wrapper).should('be.visible');
   }

   public showUpdates() {
      cy.log('Stage edit: show updates');
      this.buttons.update.scrollIntoView().click();
      cy.get(this.stagePatcherOptions.wrapper).should('be.visible');
   }

   // form.cancel buttons

   public closeDiff() {
      this.diffView.close();
   }

   public closeUpdates() {
      this.stagePatcherOptions.close();
   }

   public closeValidationModal() {
      this.validationModal.close();
   }

   public deploy(description?: string) {
      this.showDiff();
      this.diffView.deploy(description);
   }

   public createDraftDeployTicket(description?: string) {
      this.showDiff();
      this.diffView.saveDraft(description);
   }
}
