import { dataE2E, dataTest, ROUTES } from '../../utils';

import { StageButtons } from './internal/StageButtons';

import { StageBalancersPage } from './StageBalancersPage';
import { StageConfigPage } from './StageConfigPage';
import { StageDeployTicketsPage } from './StageDeployTicketsPage';
import { StageEditPage } from './StageEditPage';
import { StageHistoryPage } from './StageHistoryPage';
import { StageLogsPage } from './StageLogsPage';
import { StageMonitoringPage } from './StageMonitoringPage';
import { StageStatusPage } from './StageStatusPage';
import { StageTabPage } from './StageTabPage';

type StageTab = 'status' | 'config' | 'updates' | 'logs' | 'monitoring' | 'history' | 'deployTickets' | 'balancers';

interface TabItem {
   link: string;
   page: StageTabPage;
}

export class StagePage {
   private static createTabSelector(tabId: string) {
      return `${dataE2E('StageIndexPage:Tabs')} ${dataTest(`navigation-tabs--${tabId}`)} a`;
   }

   public pathname = ROUTES.stage(this.stageName);

   public buttons = new StageButtons();

   public balancersTab = new StageBalancersPage(this.stageName);
   public configTab = new StageConfigPage(this.stageName);
   public deployTicketsTab = new StageDeployTicketsPage(this.stageName);
   public editTab = new StageEditPage(this.stageName);
   public historyTab = new StageHistoryPage(this.stageName);
   public logsTab = new StageLogsPage(this.stageName);
   public monitoringTab = new StageMonitoringPage(this.stageName);
   public statusTab = new StageStatusPage(this.stageName);

   public tabList = new Map<StageTab, TabItem>([
      ['config', { link: StagePage.createTabSelector('config'), page: this.configTab }],
      ['logs', { link: StagePage.createTabSelector('logs'), page: this.logsTab }],
      ['monitoring', { link: StagePage.createTabSelector('monitoring'), page: this.monitoringTab }],
      ['history', { link: StagePage.createTabSelector('history'), page: this.historyTab }],
      ['deployTickets', { link: StagePage.createTabSelector('deploy-tickets'), page: this.deployTicketsTab }],
      ['balancers', { link: StagePage.createTabSelector('balancers'), page: this.balancersTab }],
      ['status', { link: StagePage.createTabSelector('status'), page: this.statusTab }],
   ]);

   public readonly tabLinks = Array.from(this.tabList.entries()).reduce((acc, [tabId, { link }]) => {
      acc[tabId] = link;

      return acc;
   }, {} as Record<StageTab, string>);

   constructor(private stageName: string) {}
}
