import { dataE2E, fieldControl, ROUTES, sel } from '../../utils';
import { FormField, TextInputField, YCSwitchField, YCSelectMultipleField } from '../components';

import { ResourceTargetSelectField } from './internal/fields/ResourceTargetSelectField';

import { StageTabPage } from './StageTabPage';

export class StageReleaseRulePage implements StageTabPage {
   public body = dataE2E('FormPageLayout');

   public buttons = {
      create: dataE2E('FormPageLayout:SubmitButton'),
      cancel: dataE2E('FormPageLayout:CancelButton'),
   };

   public form = new SandboxRuleForm(this.body);

   public pathname = ROUTES.stageDeployTickets(this.stageName);

   constructor(private stageName: string) {}
}

type ReleaseResource = {
   type: string;
   target: string;
   name: string;
};

interface SandboxRuleFormField {
   id?: string;
   description?: string;
   taskType: string;
   releaseTypes: string[];
   autocommit: boolean;
   resources: ReleaseResource[];
}

// TODO: больше похоже на BaseForm, чем на FormField???
class SandboxRuleForm implements FormField<SandboxRuleFormField> {
   public buttons = {
      addPatch: sel(dataE2E('DeployPatches:AddPatch'), 'button'),
   };

   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return undefined;
   }

   public check(v: SandboxRuleFormField) {
      // TODO
      throw new Error('TODO SandboxRuleFormField check');
   }

   public set(v: SandboxRuleFormField): void {
      const id = new TextInputField(fieldControl('id'));
      const description = new TextInputField(fieldControl('description'));
      const releaseTypes = new YCSelectMultipleField(fieldControl('releaseTypes'));
      const autocommit = new YCSwitchField(fieldControl('autocommit'));
      const taskType = new TextInputField(fieldControl('sandbox.taskType'));
      const resources = v.resources.map((resource, index) => {
         return new ResourceForm(fieldControl('sandbox'), index + 1);
      });
      if (v.id) {
         id.set(v.id);
      }
      if (v.description) {
         id.set(v.description);
      }
      releaseTypes.set(v.releaseTypes);
      autocommit.set(v.autocommit);
      taskType.set(v.taskType);

      v.resources.map((resource, index) => {
         resources[index].set(resource);
      });
   }
}

// TODO: больше похоже на BaseForm, чем на FormField???
class ResourceForm implements FormField<ReleaseResource> {
   public buttons = {
      delete: dataE2E(`DeployPatches:${this.id}:RemovePatch`),
   };

   constructor(private selector, private id) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return undefined;
   }

   public check(v: ReleaseResource) {
      // TODO
      throw new Error('TODO ReleaseResourceField check');
   }

   public set(v: ReleaseResource): void {
      const resourceType = new TextInputField(dataE2E(`DeployPatches:${this.id}:ResourceType`));
      const resourceTarget = new ResourceTargetSelectField(dataE2E(`DeployPatches:${this.id}:ResourceTarget`));
      const name = new TextInputField(dataE2E(`DeployPatches:${this.id}:Name`));

      resourceType.set(v.type);
      resourceTarget.set(v.target);
      name.set(v.name);
   }
}
