import { dataTest, ROUTES, sel, TIMEOUTS } from '../../utils';

import { StageButtons } from './internal/StageButtons';
import { StageReplicaSet } from './internal/StageReplicaSet';
import { StageTabPage } from './StageTabPage';

export class StageStatusPage implements StageTabPage {
   public body = dataTest('view-stage--status');

   // TODO починить и сделать нормальный селектор без рандомного набора спанов и дивов
   // public badge = sel(this.body, dataTest('stage--badge'));

   public pathname = ROUTES.stageStatus(this.stageName);

   public buttons = new StageButtons();

   public name = sel(this.body, dataTest('stage--name'));

   public revision = sel(this.body, dataTest('stage--revision'));

   public visit() {
      cy.log(`Stage status page: visit ${this.pathname}`);
      cy.visit(this.pathname);
      cy.get(this.body, { timeout: TIMEOUTS.slow }).should('be.visible');
   }

   public stageReadyAfterSave(revision: string) {
      this.visit();

      cy.get(sel(this.body, dataTest('stage--badge')), { timeout: TIMEOUTS.stageReadyAfterSave }).should(
         'contain.text',
         'ready',
      );

      // TODO починить TargetRev: сейчас TargetRev от Rev не отличается
      cy.get(this.revision).should('have.text', revision);
   }

   constructor(private stageName: string) {}

   public statusReplicaSet(index: number) {
      return new StageReplicaSet(index);
   }
}
