import { dataE2E, ROUTES, TIMEOUTS } from '../../utils';

import { DiffView } from './internal/DiffView';
import { StageHugeFormButtons } from './internal/StageHugeFormButtons';
import { StagePatcherOptions } from './internal/StagePatcherOptions';

import { StageTabPage } from './StageTabPage';

export class StageUpdatePage implements StageTabPage {
   public body = dataE2E('StagePatcherOptions');

   public pathname = ROUTES.stageUpdate(this.stageName);

   public buttons = new StageHugeFormButtons();

   public stagePatcherOptions = new StagePatcherOptions();

   public diffView = new DiffView();

   constructor(private stageName: string) {}

   public visit() {
      cy.log('Stage update page: visit');
      cy.visit(this.pathname);
      cy.get(this.body, { timeout: TIMEOUTS.slow }).should('be.visible');
   }

   public showDiff() {
      cy.log('Stage update page: show diff');
      this.buttons.update.should('not.be.disabled').scrollIntoView().click();
      cy.get(this.diffView.wrapper).should('be.visible');
   }
}
