import { dataE2E, sel, TIMEOUTS } from '../../../utils';

import { TextAreaField } from '../../components';

export class DiffView {
   public wrapper = dataE2E('StageDiffView');

   public buttons = {
      deploy: dataE2E('StageDiffView:DeployButton'),
      edit: dataE2E('StageDiffView:CancelButton'),
      saveAsDraft: dataE2E('StageDiffView:SaveDraftButton'),
   };

   public descriptionField = new TextAreaField(sel(this.wrapper, dataE2E('StageDiffView:Description')));

   public close() {
      cy.log('Diff view: close');

      cy.get(this.wrapper).should('be.visible');

      cy.get(this.buttons.edit).click();
   }

   public deploy(description?: string) {
      cy.log('Diff view: deploy');

      cy.get(this.wrapper).should('be.visible');

      if (description) {
         this.descriptionField.set(description);
      }

      cy.get(this.buttons.deploy, { timeout: TIMEOUTS.slow }).click();

      cy.log('waiting after update');
      cy.wait(TIMEOUTS.fast);
   }

   public saveDraft(description?: string) {
      cy.log('Diff view: save draft');

      cy.get(this.wrapper).should('be.visible');

      if (description) {
         this.descriptionField.set(description);
      }

      cy.get(this.buttons.saveAsDraft, { timeout: TIMEOUTS.slow }).click();

      // cy.log('waiting after save');
      // cy.wait(TIMEOUTS.fast);
   }

   // TODO: надёжнее проверять вложенные пути
   // no field
   public checkNotInsertedField(field: string) {
      cy.log(`check not inserted field: ${field}`);

      cy.get('td.diff-code.diff-code-insert').contains('span.token.key.atrule', field).should('not.exist');
   }

   private getClassNameByMode(mode?: '+' | '-') {
      if (!mode) {
         return '';
      }
      return mode === '+' ? '.diff-code-insert' : '.diff-code-delete';
   }

   private checkValue(field: string, value: string, mode?: '+' | '-') {
      cy.get(`td.diff-code${this.getClassNameByMode(mode)}`)
         .contains('span.token.key.atrule', new RegExp('^' + field + '$'))
         .next('span.token.punctuation')
         .parent()
         .contains(value)
         .should('exist');
   }

   // TODO: надёжнее проверять вложенные пути
   // empty value () = '""'
   public checkInsertedFieldValue(field: string, value: string) {
      cy.log(`check inserted field (${field}) value: ${value}`);
      this.checkValue(field, value, '+');
   }

   // TODO: надёжнее проверять вложенные пути
   // TODO: empty value (no field)
   public checkDeletedFieldValue(field: string, value: string) {
      cy.log(`check deleted field (${field}) value: ${value}`);
      this.checkValue(field, value, '-');
   }

   public checkFieldValue(field: string, value: string) {
      cy.log(`check field (${field}) value: ${value}`);
      this.checkValue(field, value);
   }
}
