import { dataE2E, ROUTES } from '../../../utils';

import { FormTabs } from '../../components/FormTabs';
import { BoxForm } from './levels/box/BoxForm';
import { DeployUnitForm } from './levels/deployUnit/DeployUnitForm';
import { StageForm } from './levels/stage/StageForm';
import { WorkloadForm } from './levels/workload/WorkloadForm';

class TreeItem {
   constructor(public linkSelector: string) {}
}

export class StageHugeForm {
   constructor(private idPrefix: string, private readonly: boolean) {}

   public stageForm = {
      treeItem: new TreeItem(this.getTreeItemSelector()),
      form: new StageForm(this.readonly),
   };

   public deployUnit(deployUnitId: string) {
      return {
         treeItem: new TreeItem(this.getTreeItemSelector(deployUnitId)),
         form: new DeployUnitForm(this.readonly),
         formTabs: new FormTabs(),
      };
   }

   public box(deployUnitId: string, boxId: string) {
      return {
         treeItem: new TreeItem(this.getTreeItemSelector(deployUnitId, boxId)),
         form: new BoxForm(this.readonly),
         formTabs: new FormTabs(),
      };
   }

   public workload(deployUnitId: string, boxId: string, workloadId: string) {
      return {
         treeItem: new TreeItem(this.getTreeItemSelector(deployUnitId, boxId, workloadId)),
         form: new WorkloadForm(this.readonly),
      };
   }

   private getTreeItemSelector(deployUnitId?: string, boxId?: string, workloadId?: string) {
      const nodeId = ROUTES.stageFormInternal(this.idPrefix, deployUnitId, boxId, workloadId);

      return `${dataE2E('SideTreeItem:Link')}[href="${nodeId}"]`;
   }
}
