import { dataE2E, sel } from '../../../utils';

import { StageHugeFormButtons } from './StageHugeFormButtons';

export class StagePatcherOptions {
   public wrapper = dataE2E('StagePatcherOptions');

   public buttons = new StageHugeFormButtons();

   public getActionSelector = (action: string) => sel(dataE2E(`Action:${action}`));

   public getCheckboxSelector = (action: string, deployUnitId?: string) =>
      sel(dataE2E(deployUnitId ? `Action:${deployUnitId}:${action}` : `Action:${action}`), '.checkbox', 'input');

   public close() {
      cy.log('Stage updates: close');

      cy.get(this.wrapper).should('be.visible');
      this.buttons.cancel.click();
   }

   public isEmpty() {
      cy.log('Stage updates: is empty');

      cy.get(sel(dataE2E('StagePatcherOptions')))
         .contains('Everything is up to date!')
         .should('exist');
   }

   // public update() {
   //    cy.log('Stage updates: update');

   //    cy.get(this.wrapper).should('be.visible');
   //    cy.get(this.buttons.update).click();
   // }
}
