import { dataTest } from '../../../utils';
import {
   StageStatusApprovesTab,
   StageStatusDisruptionBudgetTab,
   StageStatusEndpointsTab,
   StageStatusPodsTab,
   StageStatusStatusTab,
} from './StageStatusTabs';

export class StageReplicaSet {
   constructor(public index: number) {}

   public cardSelector = dataTest(`status--replica-set`);

   public visit(options?: Cypress.Timeoutable) {
      cy.get(this.cardSelector, options).eq(this.index).click();
   }

   public tabs = {
      pods: new StageStatusPodsTab(dataTest('StatusPage:Pods')),
      status: new StageStatusStatusTab(dataTest('StatusPage:Status')),
      endpoints: new StageStatusEndpointsTab(dataTest('StatusPage:Endpoints')),
      disruptionBudget: new StageStatusDisruptionBudgetTab(dataTest('StatusPage:DisruptionBudget')),
      approves: new StageStatusApprovesTab(dataTest('StatusPage:Approves')),
   };
}
