import { dataE2E, dataTest, sel } from '../../../utils';
import { YCRadioField, YCSelectField } from '../../components';
import { Loader } from '../../components/fields/Loader';
import { YCDropdownField } from '../../components/fields/YCDropdownField';
import { YCTab } from '../../components/internal/YCTab';

export type PodRowPart = 'self' | 'index' | 'fqdn' | 'revision' | 'host' | 'wallELink' | 'yasmLink';

export class StageStatusPodsTabRow {
   constructor(private index: number) {}

   private selector = dataTest('status--pod');

   private selectors: { [key in PodRowPart]: string } = {
      self: this.selector,
      index: sel(this.selector, dataTest('pod--index')),
      fqdn: sel(this.selector, dataTest('pod--fqdn')),
      revision: sel(this.selector, dataTest('pod--revision')),
      host: sel(this.selector, dataTest('pod--host')),
      wallELink: sel(this.selector, dataTest('pod--wall-e-link')),
      yasmLink: sel(this.selector, dataTest('pod--yasm-link')),
   };

   public additional = dataTest('pod--additional');

   public get = (part: PodRowPart) => cy.get(this.selectors[part]).eq(this.index);
}

export class StageStatusPodsTab extends YCTab {
   public filters = {
      status: new YCSelectField(dataTest('pods-filter--status')),
      revision: new YCSelectField(dataTest('pods-filter--revision')),
      location: new YCRadioField(dataTest('pods-filter--location')),
   };

   public table = {
      rows: (i: number) => new StageStatusPodsTabRow(i),
      loader: new Loader(dataTest('PodList:Loader')),
      pagination: {
         podPerPageCount: new YCDropdownField(dataE2E('Pagination:wrapper')),
         podPage: new YCRadioField(dataE2E('Pagination:wrapper')),
      },
   };
}

export class StageStatusStatusTab extends YCTab {
   // TODO
}

export class StageStatusEndpointsTab extends YCTab {
   // TODO
}

export class StageStatusDisruptionBudgetTab extends YCTab {
   // TODO
}

export class StageStatusApprovesTab extends YCTab {
   // TODO
}
