import { sel } from '../../../../utils';

import { FormField, TextInputField } from '../../../components';

export class SelectField implements FormField<string> {
   private arrow = sel(this.selector, '.select2', 'button');

   private popup = '.select2__popup';

   private searchInput = new TextInputField(sel(this.popup, '.yc-select-search', '.textinput'));

   constructor(private selector: string) {}

   public getInput(): Cypress.Chainable<JQuery> {
      return this.searchInput.getInput();
   }

   public check(v: string) {
      // TODO
      throw new Error('TODO SelectField check');
   }

   public set(v: string) {
      cy.get(this.arrow).click();

      cy.get(this.popup).find('.yc-select-item').contains(v).click();
   }
}
